/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.util;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.modscan.ModAnnotation;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.jetbrains.annotations.UnknownNullability;
import org.objectweb.asm.Type;

public class SFMAnnotationUtils {
    public static Stream<SFMAnnotationData> discoverAnnotations(Class<? extends Annotation> annotationClass) {
        Type annotationType = Type.getType(annotationClass);
        return ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(annotationData -> annotationType.equals((Object)annotationData.annotationType())).map(SFMAnnotationData::new);
    }

    public static Class<?> tryLoadAnnotatedClass(SFMAnnotationData annotation) {
        try {
            return Class.forName(annotation.clazz().getClassName(), true, SFM.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T tryConstruct(Class<?> clazz, Class<T> desiredClass) {
        if (!desiredClass.isAssignableFrom(clazz)) {
            throw new RuntimeException("Class " + clazz.getName() + " is not assignable to " + desiredClass.getName());
        }
        try {
            Object instance = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            return (T)instance;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to instantiate test builder for " + clazz.getName(), e);
        }
    }

    @MCVersionDependentBehaviour
    public static String getEnumValue(ModAnnotation.EnumHolder holder) {
        return holder.value();
    }

    public record SFMAnnotationData(ModFileScanData.AnnotationData inner) {
        public Type annotationType() {
            return this.inner.annotationType();
        }

        public ElementType targetType() {
            return this.inner.targetType();
        }

        public Map<String, Object> annotationData() {
            return this.inner.annotationData();
        }

        public String memberName() {
            return this.inner.memberName();
        }

        public Type clazz() {
            return this.inner.clazz();
        }

        public <T extends Enum<T>> EnumSet<T> getEnumSet(String key, Class<T> clazz) {
            List existing = this.annotationData().getOrDefault(key, new ArrayList());
            EnumSet<T> rtn = EnumSet.noneOf(clazz);
            for (ModAnnotation.EnumHolder enumHolder : existing) {
                rtn.add(Enum.valueOf(clazz, SFMAnnotationUtils.getEnumValue(enumHolder)));
            }
            return rtn;
        }

        public <T extends Enum<T>> @UnknownNullability T getEnum(String key, Class<T> clazz) {
            ModAnnotation.EnumHolder existing = (ModAnnotation.EnumHolder)this.annotationData().get(key);
            return existing == null ? null : (T)Enum.valueOf(clazz, SFMAnnotationUtils.getEnumValue(existing));
        }
    }
}

